#version 140
#extension GL_EXT_gpu_shader4 : enable
//Spiral RingMod01.fsh  by gaz
//https://www.shadertoy.com/view/ldtGWB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize
//#define p vec2(0.0, 0.0)

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI	3.14159265359

mat2 rotate(float a)
{
    float s=sin(a),c=cos(a);
    return mat2(c,s,-s,c);
}

float deQuad(vec2 p) {
	p = abs(p);
	return max(p.x, p.y);
}

float deHex(vec2 p) {
	p = abs(p);
	return max((2.0/sqrt(3.0))*p.x, (1.0/sqrt(3.0))*p.x + p.y);
}

float deTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float deQuadTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return deQuad(q)-t.y;
}

float deHexTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return 0.8 * (deHex(q)-t.y);
}

float deSliceTorus(in vec2 p, in vec2 t, in float a)
{
    vec3 pos = vec3(p, 0.0).xzy;
    pos.yz *= rotate(a);
    return deTorus(pos, t);
}

float deQuadSliceTorus(in vec2 p, in vec2 t, in float a)
{
    vec3 pos = vec3(p, 0.0).xzy;
    pos.yz *= rotate(a);
    return deQuadTorus(pos, t);
}
float deHexSliceTorus(in vec2 p, in vec2 t, in float a)
{
    vec3 pos = vec3(p, 0.0).xzy;
    pos.yz *= rotate(a);
    return deHexTorus(pos, t);
}

vec3 opTorusTwist(in vec3 p, in float r, in float t)
{     
    float a = atan(p.z, p.x);
    p.xz *= rotate(a);
    p.x -= r;
    p.xy *= rotate(a * t);
    return p;
}

float de1(in vec3 p)
{
    p.yx *= rotate(PI/2.0);   
    p.zx *= rotate(iTime * -0.02); 
    p  = opTorusTwist(p, 3.0, 10.0);
    return deQuadSliceTorus(p.xy, vec2(0.8, 0.1), 0.35);  
}

float de2(in vec3 p)
{
    p.yz *= rotate(iTime * 0.15); 
    p.z += 20.0;
    p.xy *= rotate(sin(iTime * 0.15)); 
    p  = opTorusTwist(p, 20.0, 20.0);
    return deHexSliceTorus(p.xy, vec2(0.8, 0.2), 0.7);    
}

float de3(in vec3 p)
{
    p.z -= 3.2;
 	return length(p) - 0.35;   
}

float map(in vec3 p)
{    
    return min(min(de1(p), de2(p)),de3(p));
}

vec3 doColor(in vec3 p)
{
    float d1 = de1(p);
    float d2 = de2(p);
    float d3 = de3(p);
    if (d1 < d2 && d1 < d3) 
    {
        p.y -= iTime * 0.07;
        return mix(texture2D(iChannel0, p.xy * 10.0).rgb ,
         vec3(0.9, 0.5, 0.2),0.5);        
    } else if (d2 < d3){
    	return mix(texture2D(iChannel0, p.xy).rgb ,
    		vec3(0.5, 0.6, 0.2),0.5);
    } else {
    	p.x -= iTime * 0.1;
        p.y -= iTime * -0.05;
        return mix(texture2D(iChannel0, p.xy).rgb ,
    		vec3(0.5, 0.6, 0.5),0.8);
    }
}

vec3 calcNormal( in vec3 pos )
{
    vec2 e = vec2(1.0, -1.0) * 0.002;
    return normalize(
        e.xyy * map(pos + e.xyy) + 
        e.yyx * map(pos + e.yyx) + 
        e.yxy * map(pos + e.yxy) +   
        e.xxx * map(pos + e.xxx));
}

float softshadow(in vec3 ro, in vec3 rd)
{
	float res = 1.0;
    float t = 0.05;
    for(int i = 0; i < 32; i++)
    {
		float h = map(ro + rd * t);
        res = min(res, 8.0 * h / t);
        t += clamp(h, 0.02, 0.1);
        if(h < 0.001 || t > 1.5) break;
    }
    return clamp(res, 0.0, 1.0);
}

float intersect(in vec3 ro, in vec3 rd)
{
    const float maxd = 50.0;
    const float precis = 0.001;
    float h = 1.0;
    float t = 0.0;
    for(int i = 0; i < 128; i++)
    {
        if(h < precis || t > maxd) break;
        h = map(ro + rd * t);
        t += h;
    }
    if( t > maxd ) t = -1.0;
    return t;
}

vec3 bg(in vec2 p , in vec2 gl_FragCoord.xy)
{   
    vec3 col = 0.2* texture2D(iChannel0, 
    	3.0 * vec2(inversesqrt(length(p)), atan(p.x, p.y) * 0.2 -iTime*0.005)).rgb;
    col = clamp(col, 0.0, 0.6);  	
    return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 p = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
    vec3 col = bg(p, gl_FragCoord.xy);
    vec3 ro = vec3(0.0, 0.0, 5.0);
    vec3 rd = normalize(vec3(p, -2.0));
    float t = intersect(ro, rd);
    if(t > -0.001)
    {
        vec3 pos = ro + t * rd;
        vec3 nor = calcNormal(pos);
		vec3 li = normalize(vec3(2.0, 2.0, 3.0));
    	col = doColor(pos);
        col *= max(dot(li, nor), 0.2);
        col *= exp(-0.001 * pos.z * pos.z);
        float sh = clamp(softshadow(pos, li), 0.4, 1.0);
        col *= sh;
        if (sh > 0.8) col += pow(max(dot(vec3(0.0, 0.0, 1.0), reflect(-li, nor)), 0.0), 60.0);
        col = pow(col, vec3(0.8)); 
    }
    gl_FragColor = vec4(col, 1.0);
}